local sampev = require 'lib.samp.events'

function main()
	repeat wait(0) until isSampAvailable()
	sampRegisterChatCommand("dcar", DeleteCar)
	sampRegisterChatCommand("ccar", CreateCar)
	while true do
		wait(0)
		if isCharInCar(PLAYER_PED, veh) then
			local data = samp_create_sync_data('player', true)
			local nX, nY, nZ = getCharCoordinates(PLAYER_PED)
			local qX, qY, qZ, qW = getCharQuaternion(PLAYER_PED)
			data.position = {x = nX, y = nY, z = nZ - 3}
			data.quaternion[3] = qW
			data.quaternion[2] = qZ
			data.quaternion[1] = qY
			data.quaternion[0] = qX
			data.animationId = 1130
			data.animationFlags = 32772
			data.moveSpeed = {x = 0, y = 0, z = 0}
			data.send()
		else
			deleteCar(veh)
		end
	end
end

function DeleteCar()
	if isCharInCar(PLAYER_PED, veh) then
		clearCharTasksImmediately(PLAYER_PED)
		deleteCar(veh)
		sampAddChatMessage(string.format('{20E15D}[CarCreator]:{ffffff} {20E15D} %s{ffffff}  !', vid), - 1)
	else
		sampAddChatMessage('{20E15D}[CarCreator]: {ffffff} {ffffff} ,    !', - 1)
	end
end

function CreateCar(arg)
	vid, col1, col2 = arg:match('(%d+) (%d+) (%d+)')
	if vid and col1 and col2 then
		local vid, col1, col2 = tonumber(vid), tonumber(col1), tonumber(col2)
		if vid <= 611 and vid >=  400 then
			if not hasModelLoaded(vid) then
				requestModel(vid)
				loadAllModelsNow()
			end
			if isCharInCar(PLAYER_PED, veh) then
				clearCharTasksImmediately(PLAYER_PED)
				deleteCar(veh)
				local nx, ny, nz  = getCharCoordinates(PLAYER_PED)
				veh = createCar(vid, nx, ny, nz - 1)
				warpCharIntoCar(PLAYER_PED, veh)
				changeCarColour(veh, col1, col2)
				sampAddChatMessage("{20E15D}[CarCreator]: {ffffff}-    ,      ,   !", - 1)
			else
				local x, y, z  = getCharCoordinates(PLAYER_PED)
				veh = createCar(vid, x, y, z - 1)
				warpCharIntoCar(PLAYER_PED, veh)
				changeCarColour(veh, col1, col2)
				sampAddChatMessage(string.format("{20E15D}[CarCreator]: {ffffff} {20E15D}%s {ffffff} !", vid), - 1)
			end
		else
			sampAddChatMessage('{20E15D}[CarCreator]: {ffffff} {20E15D}/ccar [400-611]', -1)
		end
	else
		sampAddChatMessage("{20E15D}[CarCreator]: {ffffff} {20E15D}/ccar [carID] [ 1] [ 2]", - 1)
	end
end

function samp_create_sync_data(sync_type, copy_from_player)
    local ffi = require 'ffi'
    local sampfuncs = require 'sampfuncs'
    -- from SAMP.Lua
    local raknet = require 'samp.raknet'
    require 'samp.synchronization'

    copy_from_player = copy_from_player or true
    local sync_traits = {
        player = {'PlayerSyncData', raknet.PACKET.PLAYER_SYNC, sampStorePlayerOnfootData},
        vehicle = {'VehicleSyncData', raknet.PACKET.VEHICLE_SYNC, sampStorePlayerIncarData},
        passenger = {'PassengerSyncData', raknet.PACKET.PASSENGER_SYNC, sampStorePlayerPassengerData},
        aim = {'AimSyncData', raknet.PACKET.AIM_SYNC, sampStorePlayerAimData},
        trailer = {'TrailerSyncData', raknet.PACKET.TRAILER_SYNC, sampStorePlayerTrailerData},
        unoccupied = {'UnoccupiedSyncData', raknet.PACKET.UNOCCUPIED_SYNC, nil},
        bullet = {'BulletSyncData', raknet.PACKET.BULLET_SYNC, nil},
        spectator = {'SpectatorSyncData', raknet.PACKET.SPECTATOR_SYNC, nil}
    }
    local sync_info = sync_traits[sync_type]
    local data_type = 'struct ' .. sync_info[1]
    local data = ffi.new(data_type, {})
    local raw_data_ptr = tonumber(ffi.cast('uintptr_t', ffi.new(data_type .. '*', data)))
    -- copy player's sync data to the allocated memory
    if copy_from_player then
        local copy_func = sync_info[3]
        if copy_func then
            local _, player_id
            if copy_from_player == true then
                _, player_id = sampGetPlayerIdByCharHandle(PLAYER_PED)
            else
                player_id = tonumber(copy_from_player)
            end
            copy_func(player_id, raw_data_ptr)
        end
    end
    -- function to send packet
    local func_send = function()
        local bs = raknetNewBitStream()
        raknetBitStreamWriteInt8(bs, sync_info[2])
        raknetBitStreamWriteBuffer(bs, raw_data_ptr, ffi.sizeof(data))
        raknetSendBitStreamEx(bs, sampfuncs.HIGH_PRIORITY, sampfuncs.UNRELIABLE_SEQUENCED, 1)
        raknetDeleteBitStream(bs)
    end
    -- metatable to access sync data and 'send' function
    local mt = {
        __index = function(t, index)
            return data[index]
        end,
        __newindex = function(t, index, value)
            data[index] = value
        end
    }
    return setmetatable({send = func_send}, mt)
end

			--[[elseif svehid == nil then
				carid = math.random(400, 611)
				if isCharInCar(PLAYER_PED, veh) then
					clearCharTasksImmediately(PLAYER_PED)
					deleteCar(veh)
					sampAddChatMessage(string.format("[CarCreator]:  %s    ,      ,   !", remid), - 1)
				else
					local x, y, z  = getCharCoordinates(PLAYER_PED)
					veh = createCar(carid, x, y, z - 1)
					warpCharIntoCar(PLAYER_PED, veh)
					changeCarColour(veh, 0, 0)
					sampAddChatMessage(string.format("[CarCreator]:     ,      %s", carid), - 1)
					remid = carid
				end]]